unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMObj, MMCstDlg, MMHook, MMDesign, MMDSPObj, MMWavOut, StdCtrls, MMWave,
  MMSystem, MMUtils,MMWaveIO,MMPCMSup;

type
  TForm1 = class(TForm)
    WaveFile: TMMWaveFile;
    btnStop: TButton;
    btnStart: TButton;
    WaveOut: TMMWaveOut;
    MMDesigner1: TMMDesigner;
    WaveOpenDialog: TMMWaveOpenDialog;
    procedure btnStopClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
  private
  public
    function FindSilenceStart: Longint;
    function FindSilenceEnd: Longint;
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

// this demo skips silence at the beginning and end of a wavefile

const
     SILENCE_LEVEL = 0; // change to other higher values to skip low noise too

{------------------------------------------------------------------------------}
function TForm1.FindSilenceEnd: Longint;
var
   Done: Boolean;
   tf: TMMTimeFormats;
   Buf: array[0..4095] of char;
   dwBytes,dwSilence: Longint;
begin
   Result := 0;

   // we can work with PCM files only...
   if (WaveFile.Wave.PWaveFormat.wFormatTag <> WAVE_FORMAT_PCM) then
       exit;

   tf := WaveFile.Wave.TimeFormat;   // save the TimeFormat

   WaveFile.Wave.TimeFormat := tfByte;// here we work in bytes

   WaveFile.Wave.OpenFile;
   try
      Done := False;

      WaveFile.Wave.Position := 0;

      while not Done do
      begin
         dwBytes := sizeOf(Buf);
         if (dwBytes >= WaveFile.Wave.DataSize-WaveFile.Wave.Position) then
         begin
            dwBytes := WaveFile.Wave.DataSize-WaveFile.Wave.Position;
            Done    := True; // we are at the end of the file, stop now...
         end;

         dwBytes := WaveFile.Wave.ReadDataBytes(Buf,dwBytes);

         if (dwBytes > 0) then
         begin
            pcmFindSilenceEnd(WaveFile.Wave.PWaveFormat, Buf, dwBytes, SILENCE_LEVEL, dwSilence);
            if (dwSilence >= 0) and (dwSilence <= dwBytes) then
            begin
               // found silence end
               if (dwSilence > 0) then
                   inc(Result,dwSilence);
               Done := True;
            end
            else
            begin
               // still silence, try again...
               inc(Result,dwBytes);
            end;
         end
         else break;
      end;

   finally
      WaveFile.Wave.CloseFile;
      WaveFile.Wave.TimeFormat := tf;// restore the TimeFormat

      // convert the start position to our timeformat
      case tf of
           tfByte       : ; // nothing todo
           tfMilliSecond: Result := wioBytesToTime(WaveFile.Wave.PWaveFormat,Result);
           tfSample     : Result := wioBytesToSamples(WaveFile.Wave.PWaveFormat,Result);
      end;
   end;
end;

{------------------------------------------------------------------------------}
function TForm1.FindSilenceStart: Longint;
var
   Done: Boolean;
   tf: TMMTimeFormats;
   Buf: array[0..4095] of char;
   dwRead,dwBytes,dwPos,dwSilence: Longint;
begin
   Result := WaveFile.Wave.DataSize;

   // we can work with PCM files only...
   if (WaveFile.Wave.PWaveFormat.wFormatTag <> WAVE_FORMAT_PCM) then
       exit;

   tf := WaveFile.Wave.TimeFormat;   // save the TimeFormat

   WaveFile.Wave.TimeFormat := tfByte;// here we work in bytes

   WaveFile.Wave.OpenFile;
   try
      dwRead := 0;
      Done   := False;

      WaveFile.Wave.Position := 0;

      while not Done do
      begin
         // jump to the end and read backward
         dwPos := (WaveFile.Wave.DataSize-dwRead)-sizeof(Buf);
         if (dwPos < 0) then
         begin
            dwBytes := sizeOf(Buf)-(-dwPos);
            dwPos   := 0;
            Done    := True; // we are at the beginning of the file, stop now
         end
         else dwBytes := sizeOf(Buf);

         WaveFile.Wave.Position := dwPos;

         dwBytes := WaveFile.Wave.ReadDataBytes(Buf,dwBytes);

         if (dwBytes > 0) then
         begin
            pcmFindSilenceStart(WaveFile.Wave.PWaveFormat, Buf, dwBytes, SILENCE_LEVEL, dwSilence);
            if (dwSilence >= 0) then
            begin
               // found silence start

               inc(dwRead,dwBytes);

               if (dwSilence > 0) then
               begin
                  // we have found the silence at the end
                  dec(dwRead,dwBytes-dwSilence);
                  Done := True;
               end
               else
               begin
                  // the entire buffer is silence so
                  // there must be also silence before this position
                  // just continue...
               end;
            end
            else
            begin
               // no silence in this buffer, give up...
               Done := True;
            end;
         end
         else break;
      end;

      Result := WaveFile.Wave.DataSize-dwRead;

   finally
      WaveFile.Wave.CloseFile;
      WaveFile.Wave.TimeFormat := tf;// restore the TimeFormat

      // convert the end position to our timeformat
      case tf of
           tfByte       : ; // nothing todo
           tfMilliSecond: Result := wioBytesToTime(WaveFile.Wave.PWaveFormat,Result);
           tfSample     : Result := wioBytesToSamples(WaveFile.Wave.PWaveFormat,Result);
      end;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveOut.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStartClick(Sender: TObject);
var
   sPos,ePos: Longint;
begin
   if WaveOpenDialog.Execute then
   begin
      // free the previous file
      WaveFile.Wave.FileName := '';

      WaveFile.Wave.FileName := WaveOpenDialog.FileName;

      // this can take some time (for large files)...
      Screen.Cursor := crHourGlass;
      try
         sPos := FindSilenceEnd;
         ePos := FindSilenceStart;
      finally
         Screen.Cursor := crDefault;
      end;

      WaveFile.Wave.StartPos := sPos;
      WaveFile.Wave.EndPos   := ePos;

      WaveOut.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   WaveOut.Close;
end;

end.
